package net.w_horse.excelpojo.xml;

import static org.junit.Assert.assertEquals;

import java.io.FileInputStream;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

import net.w_horse.excelpojo.AbstractTest;
import net.w_horse.excelpojo.ExcelPOJOBridge;
import net.w_horse.excelpojo.ExcelPOJOException;

import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.junit.Test;
import org.springframework.beans.factory.xml.XmlBeanDefinitionStoreException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;

import test.xml.XMLTest;
import test.xml.XMLTestElement;

public class BeanTest extends AbstractTest {
	/**
	 * sȒ`̃eXg
	 * Bean:V[gw肹Ɏ擾
	 * @throws ExcelPOJOException
	 */
	@Test(expected=ExcelPOJOException.class)
	public void testBeanNoSheetNameSpacified() throws Exception {
		try {
			ApplicationContext context = new ClassPathXmlApplicationContext("./config/testBeanNoSheetNameSpacified.xml");
			ExcelPOJOBridge bridge = (ExcelPOJOBridge)context.getBean("testBeanNoSheetNameSpacified");
			@SuppressWarnings("unused")
			XMLTest targetBean = (XMLTest) bridge.load("./files/upload/ParserTest.xls");
		} catch (Exception e) {
			assertEquals("V[gw肹Ɏ擾",
					"There is no sheet name specified.",
					e.getMessage());
			throw e;
		}
	}

	/**
	 * sȒ`̃eXg
	 * Bean:retrieveTypeLabeledCellw
	 * @throws ExcelPOJOException
	 */
	@Test(expected=ExcelPOJOException.class)
	public void testBeanRetrieveTypeLabeledCellSpacified() throws Exception {
		try {
			ApplicationContext context = new ClassPathXmlApplicationContext("./config/testBeanRetrieveTypeLabeledCellSpacified.xml");
			ExcelPOJOBridge bridge = (ExcelPOJOBridge)context.getBean("testBeanRetrieveTypeLabeledCellSpacified");
			@SuppressWarnings("unused")
			XMLTestElement targetBean = (XMLTestElement) bridge.load("./files/upload/ParserTest.xls", "{");
		} catch (Exception e) {
			assertEquals("Bean:retrieveTypeLabeledCellw",
					"There is an invalid retrieveType(labeledCell) in Bean.",
					e.getMessage());
			throw e;
		}
	}

	/**
	 * sȒ`̃eXg
	 * Bean:retrieveTypePointedCellw
	 * @throws ExcelPOJOException
	 */
	@Test(expected=ExcelPOJOException.class)
	public void testBeanRetrieveTypePointedCellSpacified() throws Exception {
		try {
			ApplicationContext context = new ClassPathXmlApplicationContext("./config/testBeanRetrieveTypePointedCellSpacified.xml");
			ExcelPOJOBridge bridge = (ExcelPOJOBridge)context.getBean("testBeanRetrieveTypePointedCellSpacified");
			@SuppressWarnings("unused")
			XMLTestElement targetBean = (XMLTestElement) bridge.load("./files/upload/ParserTest.xls", "{");
		} catch (Exception e) {
			assertEquals("Bean:retrieveTypeLabeledCellw",
					"There is an invalid retrieveType(pointedCell) in Bean.",
					e.getMessage());
			throw e;
		}
	}

	/**
	 * sȒ`̃eXg
	 * Bean:retrieveTypeConstantValuew
	 * @throws ExcelPOJOException
	 */
	@Test(expected=ExcelPOJOException.class)
	public void testBeanRetrieveTypeConstantValueSpacified() throws Exception {
		try {
			ApplicationContext context = new ClassPathXmlApplicationContext("./config/testBeanRetrieveTypeConstantValueSpacified.xml");
			ExcelPOJOBridge bridge = (ExcelPOJOBridge)context.getBean("testBeanRetrieveTypeConstantValueSpacified");
			@SuppressWarnings("unused")
			XMLTestElement targetBean = (XMLTestElement) bridge.load("./files/upload/ParserTest.xls", "{");
		} catch (Exception e) {
			assertEquals("Bean:retrieveTypeLabeledCellw",
					"There is an invalid retrieveType(constantValue) in Bean.",
					e.getMessage());
			throw e;
		}
	}

	/**
	 * sȒ`̃eXg
	 * Bean:retrieveType=verticalRepeatsw肷邪labelpositionw肵Ȃ
	 * @throws ExcelPOJOException
	 */
	@Test(expected=ExcelPOJOException.class)
	public void testBeanRetrieveTypeVerticalRepeatsNoLabelPositionSpacified() throws Exception {
		try {
			ApplicationContext context = new ClassPathXmlApplicationContext("./config/testBeanRetrieveTypeVerticalRepeatsNoLabelPositionSpacified.xml");
			ExcelPOJOBridge bridge = (ExcelPOJOBridge)context.getBean("testBeanRetrieveTypeVerticalRepeatsNoLabelPositionSpacified");
			@SuppressWarnings("unused")
			XMLTestElement targetBean = (XMLTestElement) bridge.load("./files/upload/ParserTest.xls", "{");
		} catch (Exception e) {
			assertEquals("retrieveTypew肷邪labelpositionw肵Ȃ",
					"java.lang.IllegalArgumentException: Neither the label nor the position are specified.",
					e.getMessage());
			throw e;
		}
	}

	/**
	 * sȒ`̃eXg
	 * Bean:retrieveType=horizontalRepeatsw肷邪labelpositionw肵Ȃ
	 * @throws ExcelPOJOException
	 */
	@Test(expected=ExcelPOJOException.class)
	public void testBeanRetrieveTypeHorizontalRepeatsNoLabelPositionSpacified() throws Exception {
		try {
			ApplicationContext context = new ClassPathXmlApplicationContext("./config/testBeanRetrieveTypeHorizontalRepeatsNoLabelPositionSpacified.xml");
			ExcelPOJOBridge bridge = (ExcelPOJOBridge)context.getBean("testBeanRetrieveTypeHorizontalRepeatsNoLabelPositionSpacified");
			@SuppressWarnings("unused")
			XMLTestElement targetBean = (XMLTestElement) bridge.load("./files/upload/ParserTest.xls", "{");
		} catch (Exception e) {
			assertEquals("retrieveTypew肷邪labelpositionw肵Ȃ",
					"java.lang.IllegalArgumentException: Neither the label nor the position are specified.",
					e.getMessage());
			throw e;
		}
	}

	/**
	 * sȒ`̃eXg
	 * Bean:retrieveTypeɎw肪ȂlabelɎw肪
	 * label𖳎ďsː폈
	 * @throws ExcelPOJOException
	 */
	@Test
	public void testBeanRetrieveTypeNONEButLabelSpacified() throws Exception {
		ApplicationContext context = new ClassPathXmlApplicationContext("./config/testBeanRetrieveTypeNONEButLabelSpacified.xml");
		ExcelPOJOBridge bridge = (ExcelPOJOBridge)context.getBean("testBeanRetrieveTypeNONEButLabelSpacified");
		XMLTest targetBean = (XMLTest) bridge.load("./files/upload/ParserTest.xls", "{");

		assertEquals("{i擾jFLabeledCellFString", "P", targetBean.getStringField4LabeledCell1());
		assertEquals("{i擾jFLabeledCellFint", 45, targetBean.getIntField4LabeledCell1());
		assertEquals("{i擾jFLabeledCellFboolean", true, targetBean.isBooleanField4LabeledCell1());
		assertEquals("{i擾jFLabeledCellFdouble", 78.56, targetBean.getDoubleField4LabeledCell1(), 0.001);
		assertEquals("{i擾jFLabeledCellFtij", "2010/06/18", targetBean.getDateField4LabeledCell1());

		assertEquals("{i擾jFPointedCellFString", "ʒuɂ錟F", targetBean.getStringField4PointedCell1());
		assertEquals("{i擾jFPointedCellFint", 234, targetBean.getIntField4PointedCell1());
		assertEquals("{i擾jFPointedCellFboolean", false, targetBean.isBooleanField4PointedCell1());
		assertEquals("{i擾jFPointedCellFdouble", 963.2, targetBean.getDoubleField4PointedCell1(), 0.001);
		assertEquals("{i擾jFPointedCellFtij", "2010/06/22", targetBean.getDateField4PointedCell1());

		assertEquals("{i擾jFConstantValueFString", "ŒlF", targetBean.getStringField4ConstantValue1());
		assertEquals("{i擾jFConstantValueFint", 258, targetBean.getIntField4ConstantValue1());
		assertEquals("{i擾jFConstantValueFboolean", false, targetBean.isBooleanField4ConstantValue1());
		assertEquals("{i擾jFConstantValueFdouble", 3.14, targetBean.getDoubleField4ConstantValue1(), 0.001);

		Map<String, String> countMembersMap = targetBean.getMapField4MappedCell1();
		assertEquals("{i擾jFMappedCellFLinkedHashMap", LinkedHashMap.class, countMembersMap.getClass());
		assertEquals("{i擾jFMappedCellFsize()", 4, countMembersMap.keySet().size());

		String[] keys = new String[]{"5", "6", "7", "8"};
		String[] values = new String[]{"0", "0", "1", "4"};
		int i = 0;
		for (String key : countMembersMap.keySet()) {
			assertEquals("{i擾jFMappedCellFkey" + i, keys[i], key);
			assertEquals("{i擾jFMappedCellFvalue" + i, values[i], countMembersMap.get(key));
			i++;
		}

		List<XMLTestElement> listElm = targetBean.getList4VerticalRepeats1();
		assertEquals("{i擾jFVerticalRepeatsFList", ArrayList.class, listElm.getClass());
		assertEquals("{i擾jFVerticalRepeatsFsize()", 4, listElm.size());

		XMLTestElement elm = listElm.get(0);
		assertEquals("{i擾jFVerticalRepeats(Element)Fint", 1, elm.getId());
		assertEquals("{i擾jFVerticalRepeats(Element)FString", "c", elm.getFirstName());
		assertEquals("{i擾jFVerticalRepeats(Element)FString", "M", elm.getLastName());
		assertEquals("{i擾jFVerticalRepeats(Element)Fboolean", false, elm.isPremiumMember());
		assertEquals("{i擾jFVerticalRepeats(Element)Fdouble", 175.5, elm.getTall(), 0.1);
		assertEquals("{i擾jFVerticalRepeats(Element)Ftij", "2010N611", elm.getAdmissionDay());
		Map<String, String> useTimeMap = elm.getUseTimeMap();
		assertEquals("{i擾jFMappedCellFLinkedHashMap", LinkedHashMap.class, useTimeMap.getClass());
		assertEquals("{i擾jFMappedCellFsize()", 4, useTimeMap.keySet().size());
		keys = new String[]{"5", "6", "7", "8"};
		values = new String[]{"160", "182", "165", "177"};
		i = 0;
		for (String key : useTimeMap.keySet()) {
			assertEquals("{i擾jFMappedCellFkey" + i, keys[i], key);
			assertEquals("{i擾jFMappedCellFvalue" + i, values[i], useTimeMap.get(key));
			i++;
		}

		elm = listElm.get(1);
		assertEquals("{i擾jFVerticalRepeats(Element)Fint", 2, elm.getId());
		assertEquals("{i擾jFVerticalRepeats(Element)FString", "Dc", elm.getFirstName());
		assertEquals("{i擾jFVerticalRepeats(Element)FString", "M", elm.getLastName());
		assertEquals("{i擾jFVerticalRepeats(Element)Fboolean", true, elm.isPremiumMember());
		assertEquals("{i擾jFVerticalRepeats(Element)Fdouble", 178.5, elm.getTall(), 0.1);
		assertEquals("{i擾jFVerticalRepeats(Element)Ftij", "2010N620", elm.getAdmissionDay());
		useTimeMap = elm.getUseTimeMap();
		assertEquals("{i擾jFMappedCellFLinkedHashMap", LinkedHashMap.class, useTimeMap.getClass());
		assertEquals("{i擾jFMappedCellFsize()", 4, useTimeMap.keySet().size());
		keys = new String[]{"5", "6", "7", "8"};
		values = new String[]{"193", "188", "171", "165"};
		i = 0;
		for (String key : useTimeMap.keySet()) {
			assertEquals("{i擾jFMappedCellFkey" + i, keys[i], key);
			assertEquals("{i擾jFMappedCellFvalue" + i, values[i], useTimeMap.get(key));
			i++;
		}

		elm = listElm.get(2);
		assertEquals("{i擾jFVerticalRepeats(Element)Fint", 3, elm.getId());
		assertEquals("{i擾jFVerticalRepeats(Element)FString", "", elm.getFirstName());
		assertEquals("{i擾jFVerticalRepeats(Element)FString", "ƍN", elm.getLastName());
		assertEquals("{i擾jFVerticalRepeats(Element)Fboolean", false, elm.isPremiumMember());
		assertEquals("{i擾jFVerticalRepeats(Element)Fdouble", 165.0, elm.getTall(), 0.1);
		assertEquals("{i擾jFVerticalRepeats(Element)Ftij", "2010N618", elm.getAdmissionDay());
		useTimeMap = elm.getUseTimeMap();
		assertEquals("{i擾jFMappedCellFLinkedHashMap", LinkedHashMap.class, useTimeMap.getClass());
		assertEquals("{i擾jFMappedCellFsize()", 4, useTimeMap.keySet().size());
		keys = new String[]{"5", "6", "7", "8"};
		values = new String[]{"162", "155", "165", "166"};
		i = 0;
		for (String key : useTimeMap.keySet()) {
			assertEquals("{i擾jFMappedCellFkey" + i, keys[i], key);
			assertEquals("{i擾jFMappedCellFvalue" + i, values[i], useTimeMap.get(key));
			i++;
		}

		elm = listElm.get(3);
		assertEquals("{i擾jFVerticalRepeats(Element)Fint", 4, elm.getId());
		assertEquals("{i擾jFVerticalRepeats(Element)FString", "א", elm.getFirstName());
		assertEquals("{i擾jFVerticalRepeats(Element)FString", "KV", elm.getLastName());
		assertEquals("{i擾jFVerticalRepeats(Element)Fboolean", false, elm.isPremiumMember());
		assertEquals("{i擾jFVerticalRepeats(Element)Fdouble", 160.0, elm.getTall(), 0.1);
		assertEquals("{i擾jFVerticalRepeats(Element)Ftij", "2010N622", elm.getAdmissionDay());
		useTimeMap = elm.getUseTimeMap();
		assertEquals("{i擾jFMappedCellFLinkedHashMap", LinkedHashMap.class, useTimeMap.getClass());
		assertEquals("{i擾jFMappedCellFsize()", 4, useTimeMap.keySet().size());
		keys = new String[]{"5", "6", "7", "8"};
		values = new String[]{"143", "177", "151", "182"};
		i = 0;
		for (String key : useTimeMap.keySet()) {
			assertEquals("{i擾jFMappedCellFkey" + i, keys[i], key);
			assertEquals("{i擾jFMappedCellFvalue" + i, values[i], useTimeMap.get(key));
			i++;
		}

		XMLTestElement[] arrElm = targetBean.getArr4VerticalRepeats1();
		assertEquals("{i擾jFVerticalRepeatsFArray", XMLTestElement[].class, arrElm.getClass());
		assertEquals("{i擾jFVerticalRepeatsFsize()", 2, arrElm.length);

		elm = arrElm[0];
		assertEquals("{i擾jFVerticalRepeats(Element)Fint", 1, elm.getId());
		assertEquals("{i擾jFVerticalRepeats(Element)FString", "", elm.getFirstName());
		assertEquals("{i擾jFVerticalRepeats(Element)FString", "܂", elm.getLastName());
		assertEquals("{i擾jFVerticalRepeats(Element)Fboolean", true, elm.isPremiumMember());
		assertEquals("{i擾jFVerticalRepeats(Element)Fdouble", 156.0, elm.getTall(), 0.1);
		assertEquals("{i擾jFVerticalRepeats(Element)Ftij", "2010N615", elm.getAdmissionDay());
		useTimeMap = elm.getUseTimeMap();
		assertEquals("{i擾jFMappedCellFLinkedHashMap", LinkedHashMap.class, useTimeMap.getClass());
		assertEquals("{i擾jFMappedCellFsize()", 4, useTimeMap.keySet().size());
		keys = new String[]{"5", "6", "7", "8"};
		values = new String[]{"90", "56", "81", "23"};
		i = 0;
		for (String key : useTimeMap.keySet()) {
			assertEquals("{i擾jFMappedCellFkey" + i, keys[i], key);
			assertEquals("{i擾jFMappedCellFvalue" + i, values[i], useTimeMap.get(key));
			i++;
		}

		elm = arrElm[1];
		assertEquals("{i擾jFVerticalRepeats(Element)Fint", 2, elm.getId());
		assertEquals("{i擾jFVerticalRepeats(Element)FString", "", elm.getFirstName());
		assertEquals("{i擾jFVerticalRepeats(Element)FString", "", elm.getLastName());
		assertEquals("{i擾jFVerticalRepeats(Element)Fboolean", false, elm.isPremiumMember());
		assertEquals("{i擾jFVerticalRepeats(Element)Fdouble", 168.5, elm.getTall(), 0.1);
		assertEquals("{i擾jFVerticalRepeats(Element)Ftij", "2010N617", elm.getAdmissionDay());
		useTimeMap = elm.getUseTimeMap();
		assertEquals("{i擾jFMappedCellFLinkedHashMap", LinkedHashMap.class, useTimeMap.getClass());
		assertEquals("{i擾jFMappedCellFsize()", 4, useTimeMap.keySet().size());
		keys = new String[]{"5", "6", "7", "8"};
		values = new String[]{"112", "186", "78", "140"};
		i = 0;
		for (String key : useTimeMap.keySet()) {
			assertEquals("{i擾jFMappedCellFkey" + i, keys[i], key);
			assertEquals("{i擾jFMappedCellFvalue" + i, values[i], useTimeMap.get(key));
			i++;
		}

		listElm = targetBean.getList4HorizontalRepeats1();
		assertEquals("{i擾jFVerticalRepeatsFList", ArrayList.class, listElm.getClass());
		assertEquals("{i擾jFVerticalRepeatsFsize()", 4, listElm.size());

		elm = listElm.get(0);
		assertEquals("{i擾jFVerticalRepeats(Element)Fint", 1, elm.getId());
		assertEquals("{i擾jFVerticalRepeats(Element)FString", "cH", elm.getFirstName());
		assertEquals("{i擾jFVerticalRepeats(Element)FString", "MH", elm.getLastName());
		assertEquals("{i擾jFVerticalRepeats(Element)Fboolean", false, elm.isPremiumMember());
		assertEquals("{i擾jFVerticalRepeats(Element)Fdouble", 175.5, elm.getTall(), 0.1);
		assertEquals("{i擾jFVerticalRepeats(Element)Ftij", "2010N611", elm.getAdmissionDay());
		useTimeMap = elm.getUseTimeMap();
		assertEquals("{i擾jFMappedCellFLinkedHashMap", LinkedHashMap.class, useTimeMap.getClass());
		assertEquals("{i擾jFMappedCellFsize()", 4, useTimeMap.keySet().size());
		keys = new String[]{"5", "6", "7", "8"};
		values = new String[]{"160", "182", "165", "177"};
		i = 0;
		for (String key : useTimeMap.keySet()) {
			assertEquals("{i擾jFMappedCellFkey" + i, keys[i], key);
			assertEquals("{i擾jFMappedCellFvalue" + i, values[i], useTimeMap.get(key));
			i++;
		}

		elm = listElm.get(1);
		assertEquals("{i擾jFVerticalRepeats(Element)Fint", 2, elm.getId());
		assertEquals("{i擾jFVerticalRepeats(Element)FString", "DcH", elm.getFirstName());
		assertEquals("{i擾jFVerticalRepeats(Element)FString", "MH", elm.getLastName());
		assertEquals("{i擾jFVerticalRepeats(Element)Fboolean", true, elm.isPremiumMember());
		assertEquals("{i擾jFVerticalRepeats(Element)Fdouble", 178.5, elm.getTall(), 0.1);
		assertEquals("{i擾jFVerticalRepeats(Element)Ftij", "2010N620", elm.getAdmissionDay());
		useTimeMap = elm.getUseTimeMap();
		assertEquals("{i擾jFMappedCellFLinkedHashMap", LinkedHashMap.class, useTimeMap.getClass());
		assertEquals("{i擾jFMappedCellFsize()", 4, useTimeMap.keySet().size());
		keys = new String[]{"5", "6", "7", "8"};
		values = new String[]{"193", "188", "171", "165"};
		i = 0;
		for (String key : useTimeMap.keySet()) {
			assertEquals("{i擾jFMappedCellFkey" + i, keys[i], key);
			assertEquals("{i擾jFMappedCellFvalue" + i, values[i], useTimeMap.get(key));
			i++;
		}

		elm = listElm.get(2);
		assertEquals("{i擾jFVerticalRepeats(Element)Fint", 3, elm.getId());
		assertEquals("{i擾jFVerticalRepeats(Element)FString", "H", elm.getFirstName());
		assertEquals("{i擾jFVerticalRepeats(Element)FString", "ƍNH", elm.getLastName());
		assertEquals("{i擾jFVerticalRepeats(Element)Fboolean", false, elm.isPremiumMember());
		assertEquals("{i擾jFVerticalRepeats(Element)Fdouble", 165.0, elm.getTall(), 0.1);
		assertEquals("{i擾jFVerticalRepeats(Element)Ftij", "2010N618", elm.getAdmissionDay());
		useTimeMap = elm.getUseTimeMap();
		assertEquals("{i擾jFMappedCellFLinkedHashMap", LinkedHashMap.class, useTimeMap.getClass());
		assertEquals("{i擾jFMappedCellFsize()", 4, useTimeMap.keySet().size());
		keys = new String[]{"5", "6", "7", "8"};
		values = new String[]{"162", "155", "165", "166"};
		i = 0;
		for (String key : useTimeMap.keySet()) {
			assertEquals("{i擾jFMappedCellFkey" + i, keys[i], key);
			assertEquals("{i擾jFMappedCellFvalue" + i, values[i], useTimeMap.get(key));
			i++;
		}

		elm = listElm.get(3);
		assertEquals("{i擾jFVerticalRepeats(Element)Fint", 4, elm.getId());
		assertEquals("{i擾jFVerticalRepeats(Element)FString", "אH", elm.getFirstName());
		assertEquals("{i擾jFVerticalRepeats(Element)FString", "KVH", elm.getLastName());
		assertEquals("{i擾jFVerticalRepeats(Element)Fboolean", false, elm.isPremiumMember());
		assertEquals("{i擾jFVerticalRepeats(Element)Fdouble", 160.0, elm.getTall(), 0.1);
		assertEquals("{i擾jFVerticalRepeats(Element)Ftij", "2010N622", elm.getAdmissionDay());
		useTimeMap = elm.getUseTimeMap();
		assertEquals("{i擾jFMappedCellFLinkedHashMap", LinkedHashMap.class, useTimeMap.getClass());
		assertEquals("{i擾jFMappedCellFsize()", 4, useTimeMap.keySet().size());
		keys = new String[]{"5", "6", "7", "8"};
		values = new String[]{"143", "177", "151", "182"};
		i = 0;
		for (String key : useTimeMap.keySet()) {
			assertEquals("{i擾jFMappedCellFkey" + i, keys[i], key);
			assertEquals("{i擾jFMappedCellFvalue" + i, values[i], useTimeMap.get(key));
			i++;
		}

		arrElm = targetBean.getArr4HorizontalRepeats1();
		assertEquals("{i擾jFVerticalRepeatsFArray", XMLTestElement[].class, arrElm.getClass());
		assertEquals("{i擾jFVerticalRepeatsFsize()", 2, arrElm.length);

		elm = arrElm[0];
		assertEquals("{i擾jFVerticalRepeats(Element)Fint", 1, elm.getId());
		assertEquals("{i擾jFVerticalRepeats(Element)FString", "H", elm.getFirstName());
		assertEquals("{i擾jFVerticalRepeats(Element)FString", "܂H", elm.getLastName());
		assertEquals("{i擾jFVerticalRepeats(Element)Fboolean", true, elm.isPremiumMember());
		assertEquals("{i擾jFVerticalRepeats(Element)Fdouble", 156.0, elm.getTall(), 0.1);
		assertEquals("{i擾jFVerticalRepeats(Element)Ftij", "2010N615", elm.getAdmissionDay());
		useTimeMap = elm.getUseTimeMap();
		assertEquals("{i擾jFMappedCellFLinkedHashMap", LinkedHashMap.class, useTimeMap.getClass());
		assertEquals("{i擾jFMappedCellFsize()", 4, useTimeMap.keySet().size());
		keys = new String[]{"5", "6", "7", "8"};
		values = new String[]{"90", "56", "81", "23"};
		i = 0;
		for (String key : useTimeMap.keySet()) {
			assertEquals("{i擾jFMappedCellFkey" + i, keys[i], key);
			assertEquals("{i擾jFMappedCellFvalue" + i, values[i], useTimeMap.get(key));
			i++;
		}

		elm = arrElm[1];
		assertEquals("{i擾jFVerticalRepeats(Element)Fint", 2, elm.getId());
		assertEquals("{i擾jFVerticalRepeats(Element)FString", "H", elm.getFirstName());
		assertEquals("{i擾jFVerticalRepeats(Element)FString", "H", elm.getLastName());
		assertEquals("{i擾jFVerticalRepeats(Element)Fboolean", false, elm.isPremiumMember());
		assertEquals("{i擾jFVerticalRepeats(Element)Fdouble", 168.5, elm.getTall(), 0.1);
		assertEquals("{i擾jFVerticalRepeats(Element)Ftij", "2010N617", elm.getAdmissionDay());
		useTimeMap = elm.getUseTimeMap();
		assertEquals("{i擾jFMappedCellFLinkedHashMap", LinkedHashMap.class, useTimeMap.getClass());
		assertEquals("{i擾jFMappedCellFsize()", 4, useTimeMap.keySet().size());
		keys = new String[]{"5", "6", "7", "8"};
		values = new String[]{"112", "186", "78", "140"};
		i = 0;
		for (String key : useTimeMap.keySet()) {
			assertEquals("{i擾jFMappedCellFkey" + i, keys[i], key);
			assertEquals("{i擾jFMappedCellFvalue" + i, values[i], useTimeMap.get(key));
			i++;
		}


		bridge.save(
				"./files/template/ParserTest_Template.xls",
				"{",
				"./files/export/AnnotationParserTest_{.xls",
				targetBean);

		FileInputStream fileInputStream = null;
		try {
			fileInputStream = new FileInputStream("./files/export/AnnotationParserTest_{.xls");
			HSSFWorkbook workBook = new HSSFWorkbook(new POIFSFileSystem(fileInputStream));
			HSSFSheet sheet = workBook.getSheet("{");

			assertEquals("{i݁jFLabeledCellFString", "P", getCellValue(sheet, 42, 9, CELL_TYPE_STRING));
			assertEquals("{i݁jFLabeledCellFint", 45, getCellValue(sheet, 43, 9, CELL_TYPE_INT));
			assertEquals("{i݁jFLabeledCellFboolean", true, getCellValue(sheet, 44, 9, CELL_TYPE_BOOLEAN));
			assertEquals("{i݁jFLabeledCellFdouble", 78.56, (Double)getCellValue(sheet, 45, 9, CELL_TYPE_DOUBLE), 0.001);
			assertEquals("{i݁jFLabeledCellFtij", "2010/06/18", getCellValue(sheet, 46, 9, CELL_TYPE_DATE_STR));

			assertEquals("{i݁jFPointedCellFString", "ʒuɂ錟F", getCellValue(sheet, 14, 3, CELL_TYPE_STRING));
			assertEquals("{i݁jFPointedCellFint",234, getCellValue(sheet, 15, 3, CELL_TYPE_INT));
			assertEquals("{i݁jFPointedCellFboolean",false, getCellValue(sheet, 16, 3, CELL_TYPE_BOOLEAN));
			assertEquals("{i݁jFPointedCellFdouble",963.2, (Double)getCellValue(sheet, 17, 3, CELL_TYPE_DOUBLE), 0.001);
			assertEquals("{i݁jFPointedCellFtij","2010/06/22", getCellValue(sheet, 18, 3, CELL_TYPE_DATE_STR));

			assertEquals("{i݁jFMappedCellFkey1","5", getCellValue(sheet, 21, 2, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval1","0",   getCellValue(sheet, 22, 2, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFkey2","6", getCellValue(sheet, 21, 3, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval2","0",   getCellValue(sheet, 22, 3, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFkey3","7", getCellValue(sheet, 21, 4, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval3","1",   getCellValue(sheet, 22, 4, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFkey4","8", getCellValue(sheet, 21, 5, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval4","4",   getCellValue(sheet, 22, 5, CELL_TYPE_DATE_STR));

			assertEquals("{i݁jFVerticalRepeats(Element)Fint", 1, getCellValue(sheet, 3, 2, CELL_TYPE_INT));
			assertEquals("{i݁jFVerticalRepeats(Element)FString", "c", getCellValue(sheet, 3, 5, CELL_TYPE_STRING));
			assertEquals("{i݁jFVerticalRepeats(Element)FString", "M", getCellValue(sheet, 3, 6, CELL_TYPE_STRING));
			assertEquals("{i݁jFVerticalRepeats(Element)Fboolean", false, getCellValue(sheet, 3, 9, CELL_TYPE_BOOLEAN));
			assertEquals("{i݁jFVerticalRepeats(Element)Fdouble", 175.5, (Double)getCellValue(sheet, 3, 11, CELL_TYPE_DOUBLE), 0.1);
			assertEquals("{i݁jFVerticalRepeats(Element)Ftij", "2010N611", getCellValue(sheet, 3, 10, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFkey1","5", getCellValue(sheet, 2, 13, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFkey2","6", getCellValue(sheet, 2, 14, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFkey3","7", getCellValue(sheet, 2, 15, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFkey4","8", getCellValue(sheet, 2, 16, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval1","160", getCellValue(sheet, 3, 13, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval2","182", getCellValue(sheet, 3, 14, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval3","165", getCellValue(sheet, 3, 15, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval4","177", getCellValue(sheet, 3, 16, CELL_TYPE_DATE_STR));

			assertEquals("{i݁jFVerticalRepeats(Element)Fint", 2, getCellValue(sheet, 4, 2, CELL_TYPE_INT));
			assertEquals("{i݁jFVerticalRepeats(Element)FString", "Dc", getCellValue(sheet, 4, 5, CELL_TYPE_STRING));
			assertEquals("{i݁jFVerticalRepeats(Element)FString", "M", getCellValue(sheet, 4, 6, CELL_TYPE_STRING));
			assertEquals("{i݁jFVerticalRepeats(Element)Fboolean", true, getCellValue(sheet, 4, 9, CELL_TYPE_BOOLEAN));
			assertEquals("{i݁jFVerticalRepeats(Element)Fdouble", 178.5, (Double)getCellValue(sheet, 4, 11, CELL_TYPE_DOUBLE), 0.1);
			assertEquals("{i݁jFVerticalRepeats(Element)Ftij", "2010N620", getCellValue(sheet, 4, 10, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval1","193", getCellValue(sheet, 4, 13, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval2","188", getCellValue(sheet, 4, 14, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval3","171", getCellValue(sheet, 4, 15, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval4","165", getCellValue(sheet, 4, 16, CELL_TYPE_DATE_STR));

			assertEquals("{i݁jFVerticalRepeats(Element)Fint", 3, getCellValue(sheet, 5, 2, CELL_TYPE_INT));
			assertEquals("{i݁jFVerticalRepeats(Element)FString", "", getCellValue(sheet, 5, 5, CELL_TYPE_STRING));
			assertEquals("{i݁jFVerticalRepeats(Element)FString", "ƍN", getCellValue(sheet, 5, 6, CELL_TYPE_STRING));
			assertEquals("{i݁jFVerticalRepeats(Element)Fboolean", false, getCellValue(sheet, 5, 9, CELL_TYPE_BOOLEAN));
			assertEquals("{i݁jFVerticalRepeats(Element)Fdouble", 165.0, (Double)getCellValue(sheet, 5, 11, CELL_TYPE_DOUBLE), 0.1);
			assertEquals("{i݁jFVerticalRepeats(Element)Ftij", "2010N618", getCellValue(sheet, 5, 10, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval1","162", getCellValue(sheet, 5, 13, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval2","155", getCellValue(sheet, 5, 14, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval3","165", getCellValue(sheet, 5, 15, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval4","166", getCellValue(sheet, 5, 16, CELL_TYPE_DATE_STR));

			assertEquals("{i݁jFVerticalRepeats(Element)Fint", 4, getCellValue(sheet, 6, 2, CELL_TYPE_INT));
			assertEquals("{i݁jFVerticalRepeats(Element)FString", "א", getCellValue(sheet, 6, 5, CELL_TYPE_STRING));
			assertEquals("{i݁jFVerticalRepeats(Element)FString", "KV", getCellValue(sheet, 6, 6, CELL_TYPE_STRING));
			assertEquals("{i݁jFVerticalRepeats(Element)Fboolean", false, getCellValue(sheet, 6, 9, CELL_TYPE_BOOLEAN));
			assertEquals("{i݁jFVerticalRepeats(Element)Fdouble", 160.0, (Double)getCellValue(sheet, 6, 11, CELL_TYPE_DOUBLE), 0.1);
			assertEquals("{i݁jFVerticalRepeats(Element)Ftij", "2010N622", getCellValue(sheet, 6, 10, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval1","143", getCellValue(sheet, 6, 13, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval2","177", getCellValue(sheet, 6, 14, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval3","151", getCellValue(sheet, 6, 15, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval4","182", getCellValue(sheet, 6, 16, CELL_TYPE_DATE_STR));

			assertEquals("{i݁jFVerticalRepeats(Element)Fint", 1, getCellValue(sheet, 29, 2, CELL_TYPE_INT));
			assertEquals("{i݁jFVerticalRepeats(Element)FString", "", getCellValue(sheet, 29, 4, CELL_TYPE_STRING));
			assertEquals("{i݁jFVerticalRepeats(Element)FString", "܂", getCellValue(sheet, 29, 5, CELL_TYPE_STRING));
			assertEquals("{i݁jFVerticalRepeats(Element)Fboolean", true, getCellValue(sheet, 29, 7, CELL_TYPE_BOOLEAN));
			assertEquals("{i݁jFVerticalRepeats(Element)Fdouble", 156.0, (Double)getCellValue(sheet, 29, 8, CELL_TYPE_DOUBLE), 0.1);
			assertEquals("{i݁jFVerticalRepeats(Element)Ftij", "2010N615", getCellValue(sheet, 29, 6, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFkey1","5", getCellValue(sheet, 28, 14, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFkey2","6", getCellValue(sheet, 28, 15, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFkey3","7", getCellValue(sheet, 28, 16, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFkey4","8", getCellValue(sheet, 28, 17, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval1","90", getCellValue(sheet, 29, 14, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval2","56", getCellValue(sheet, 29, 15, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval3","81", getCellValue(sheet, 29, 16, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval4","23", getCellValue(sheet, 29, 17, CELL_TYPE_DATE_STR));

			assertEquals("{i݁jFVerticalRepeats(Element)Fint", 2, getCellValue(sheet, 30, 2, CELL_TYPE_INT));
			assertEquals("{i݁jFVerticalRepeats(Element)FString", "", getCellValue(sheet, 30, 4, CELL_TYPE_STRING));
			assertEquals("{i݁jFVerticalRepeats(Element)FString", "", getCellValue(sheet, 30, 5, CELL_TYPE_STRING));
			assertEquals("{i݁jFVerticalRepeats(Element)Fboolean", false, getCellValue(sheet, 30, 7, CELL_TYPE_BOOLEAN));
			assertEquals("{i݁jFVerticalRepeats(Element)Fdouble", 168.5, (Double)getCellValue(sheet, 30, 8, CELL_TYPE_DOUBLE), 0.1);
			assertEquals("{i݁jFVerticalRepeats(Element)Ftij", "2010N617", getCellValue(sheet, 30, 6, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval1","112", getCellValue(sheet, 30, 14, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval2","186", getCellValue(sheet, 30, 15, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval3","78", getCellValue(sheet, 30, 16, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval4","140", getCellValue(sheet, 30, 17, CELL_TYPE_DATE_STR));

			assertEquals("{i݁jFVerticalRepeats(Element)Fint", 1, getCellValue(sheet, 50, 3, CELL_TYPE_INT));
			assertEquals("{i݁jFVerticalRepeats(Element)FString", "cH", getCellValue(sheet, 53, 3, CELL_TYPE_STRING));
			assertEquals("{i݁jFVerticalRepeats(Element)FString", "MH", getCellValue(sheet, 54, 3, CELL_TYPE_STRING));
			assertEquals("{i݁jFVerticalRepeats(Element)Fboolean", false, getCellValue(sheet, 60, 3, CELL_TYPE_BOOLEAN));
			assertEquals("{i݁jFVerticalRepeats(Element)Fdouble", 175.5, (Double)getCellValue(sheet, 59, 3, CELL_TYPE_DOUBLE), 0.1);
			assertEquals("{i݁jFVerticalRepeats(Element)Ftij", "2010N611", getCellValue(sheet, 52, 3, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFkey1","5", getCellValue(sheet, 62, 2, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFkey2","6", getCellValue(sheet, 63, 2, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFkey3","7", getCellValue(sheet, 64, 2, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFkey4","8", getCellValue(sheet, 65, 2, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval1","160", getCellValue(sheet, 62, 3, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval2","182", getCellValue(sheet, 63, 3, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval3","165", getCellValue(sheet, 64, 3, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval4","177", getCellValue(sheet, 65, 3, CELL_TYPE_DATE_STR));

			assertEquals("{i݁jFVerticalRepeats(Element)Fint", 2, getCellValue(sheet, 50, 4, CELL_TYPE_INT));
			assertEquals("{i݁jFVerticalRepeats(Element)FString", "DcH", getCellValue(sheet, 53, 4, CELL_TYPE_STRING));
			assertEquals("{i݁jFVerticalRepeats(Element)FString", "MH", getCellValue(sheet, 54, 4, CELL_TYPE_STRING));
			assertEquals("{i݁jFVerticalRepeats(Element)Fboolean", true, getCellValue(sheet, 60, 4, CELL_TYPE_BOOLEAN));
			assertEquals("{i݁jFVerticalRepeats(Element)Fdouble", 178.5, (Double)getCellValue(sheet, 59, 4, CELL_TYPE_DOUBLE), 0.1);
			assertEquals("{i݁jFVerticalRepeats(Element)Ftij", "2010N620", getCellValue(sheet, 52, 4, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval1","193", getCellValue(sheet, 62, 4, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval2","188", getCellValue(sheet, 63, 4, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval3","171", getCellValue(sheet, 64, 4, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval4","165", getCellValue(sheet, 65, 4, CELL_TYPE_DATE_STR));

			assertEquals("{i݁jFVerticalRepeats(Element)Fint", 3, getCellValue(sheet, 50, 5, CELL_TYPE_INT));
			assertEquals("{i݁jFVerticalRepeats(Element)FString", "H", getCellValue(sheet, 53, 5, CELL_TYPE_STRING));
			assertEquals("{i݁jFVerticalRepeats(Element)FString", "ƍNH", getCellValue(sheet, 54, 5, CELL_TYPE_STRING));
			assertEquals("{i݁jFVerticalRepeats(Element)Fboolean", false, getCellValue(sheet, 60, 5, CELL_TYPE_BOOLEAN));
			assertEquals("{i݁jFVerticalRepeats(Element)Fdouble", 165.0, (Double)getCellValue(sheet, 59, 5, CELL_TYPE_DOUBLE), 0.1);
			assertEquals("{i݁jFVerticalRepeats(Element)Ftij", "2010N618", getCellValue(sheet, 52, 5, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval1","162", getCellValue(sheet, 62, 5, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval2","155", getCellValue(sheet, 63, 5, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval3","165", getCellValue(sheet, 64, 5, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval4","166", getCellValue(sheet, 65, 5, CELL_TYPE_DATE_STR));

			assertEquals("{i݁jFVerticalRepeats(Element)Fint", 4, getCellValue(sheet, 50, 6, CELL_TYPE_INT));
			assertEquals("{i݁jFVerticalRepeats(Element)FString", "אH", getCellValue(sheet, 53, 6, CELL_TYPE_STRING));
			assertEquals("{i݁jFVerticalRepeats(Element)FString", "KVH", getCellValue(sheet, 54, 6, CELL_TYPE_STRING));
			assertEquals("{i݁jFVerticalRepeats(Element)Fboolean", false, getCellValue(sheet, 60, 9, CELL_TYPE_BOOLEAN));
			assertEquals("{i݁jFVerticalRepeats(Element)Fdouble", 160.0, (Double)getCellValue(sheet, 59, 6, CELL_TYPE_DOUBLE), 0.1);
			assertEquals("{i݁jFVerticalRepeats(Element)Ftij", "2010N622", getCellValue(sheet, 52, 6, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval1","143", getCellValue(sheet, 62, 6, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval2","177", getCellValue(sheet, 63, 6, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval3","151", getCellValue(sheet, 64, 6, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval4","182", getCellValue(sheet, 65, 6, CELL_TYPE_DATE_STR));

			assertEquals("{i݁jFVerticalRepeats(Element)Fint", 1, getCellValue(sheet, 77, 3, CELL_TYPE_INT));
			assertEquals("{i݁jFVerticalRepeats(Element)FString", "H", getCellValue(sheet, 80, 3, CELL_TYPE_STRING));
			assertEquals("{i݁jFVerticalRepeats(Element)FString", "܂H", getCellValue(sheet, 81, 3, CELL_TYPE_STRING));
			assertEquals("{i݁jFVerticalRepeats(Element)Fboolean", true, getCellValue(sheet, 78, 3, CELL_TYPE_BOOLEAN));
			assertEquals("{i݁jFVerticalRepeats(Element)Fdouble", 156.0, (Double)getCellValue(sheet, 87, 3, CELL_TYPE_DOUBLE), 0.1);
			assertEquals("{i݁jFVerticalRepeats(Element)Ftij", "2010N615", getCellValue(sheet, 79, 3, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFkey1","5", getCellValue(sheet, 89, 2, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFkey2","6", getCellValue(sheet, 90, 2, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFkey3","7", getCellValue(sheet, 91, 2, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFkey4","8", getCellValue(sheet, 92, 2, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval1","90", getCellValue(sheet, 89, 3, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval2","56", getCellValue(sheet, 90, 3, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval3","81", getCellValue(sheet, 91, 3, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval4","23", getCellValue(sheet, 92, 3, CELL_TYPE_DATE_STR));

			assertEquals("{i݁jFVerticalRepeats(Element)Fint", 2, getCellValue(sheet, 77, 4, CELL_TYPE_INT));
			assertEquals("{i݁jFVerticalRepeats(Element)FString", "H", getCellValue(sheet, 80, 4, CELL_TYPE_STRING));
			assertEquals("{i݁jFVerticalRepeats(Element)FString", "H", getCellValue(sheet, 81, 4, CELL_TYPE_STRING));
			assertEquals("{i݁jFVerticalRepeats(Element)Fboolean", false, getCellValue(sheet, 78, 4, CELL_TYPE_BOOLEAN));
			assertEquals("{i݁jFVerticalRepeats(Element)Fdouble", 168.5, (Double)getCellValue(sheet, 87, 4, CELL_TYPE_DOUBLE), 0.1);
			assertEquals("{i݁jFVerticalRepeats(Element)Ftij", "2010N617", getCellValue(sheet, 79, 4, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval1","112", getCellValue(sheet, 89, 4, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval2","186", getCellValue(sheet, 90, 4, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval3","78", getCellValue(sheet, 91, 4, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval4","140", getCellValue(sheet, 92, 4, CELL_TYPE_DATE_STR));
		} finally {
			try { fileInputStream.close(); } catch (Exception e) { }
		}
	}

	/**
	 * sȒ`̃eXg
	 * Bean:retrieveTypeɎw肪ȂpositionɎw肪
	 * label𖳎ďsː폈
	 * @throws ExcelPOJOException
	 */
	@Test
	public void testBeanRetrieveTypeNONEButPositionSpacified() throws Exception {
		ApplicationContext context = new ClassPathXmlApplicationContext("./config/testBeanRetrieveTypeNONEButPositionSpacified.xml");
		ExcelPOJOBridge bridge = (ExcelPOJOBridge)context.getBean("testBeanRetrieveTypeNONEButPositionSpacified");
		XMLTest targetBean = (XMLTest) bridge.load("./files/upload/ParserTest.xls", "{");

		assertEquals("{i擾jFLabeledCellFString", "P", targetBean.getStringField4LabeledCell1());
		assertEquals("{i擾jFLabeledCellFint", 45, targetBean.getIntField4LabeledCell1());
		assertEquals("{i擾jFLabeledCellFboolean", true, targetBean.isBooleanField4LabeledCell1());
		assertEquals("{i擾jFLabeledCellFdouble", 78.56, targetBean.getDoubleField4LabeledCell1(), 0.001);
		assertEquals("{i擾jFLabeledCellFtij", "2010/06/18", targetBean.getDateField4LabeledCell1());

		assertEquals("{i擾jFPointedCellFString", "ʒuɂ錟F", targetBean.getStringField4PointedCell1());
		assertEquals("{i擾jFPointedCellFint", 234, targetBean.getIntField4PointedCell1());
		assertEquals("{i擾jFPointedCellFboolean", false, targetBean.isBooleanField4PointedCell1());
		assertEquals("{i擾jFPointedCellFdouble", 963.2, targetBean.getDoubleField4PointedCell1(), 0.001);
		assertEquals("{i擾jFPointedCellFtij", "2010/06/22", targetBean.getDateField4PointedCell1());

		assertEquals("{i擾jFConstantValueFString", "ŒlF", targetBean.getStringField4ConstantValue1());
		assertEquals("{i擾jFConstantValueFint", 258, targetBean.getIntField4ConstantValue1());
		assertEquals("{i擾jFConstantValueFboolean", false, targetBean.isBooleanField4ConstantValue1());
		assertEquals("{i擾jFConstantValueFdouble", 3.14, targetBean.getDoubleField4ConstantValue1(), 0.001);

		Map<String, String> countMembersMap = targetBean.getMapField4MappedCell1();
		assertEquals("{i擾jFMappedCellFLinkedHashMap", LinkedHashMap.class, countMembersMap.getClass());
		assertEquals("{i擾jFMappedCellFsize()", 4, countMembersMap.keySet().size());

		String[] keys = new String[]{"5", "6", "7", "8"};
		String[] values = new String[]{"0", "0", "1", "4"};
		int i = 0;
		for (String key : countMembersMap.keySet()) {
			assertEquals("{i擾jFMappedCellFkey" + i, keys[i], key);
			assertEquals("{i擾jFMappedCellFvalue" + i, values[i], countMembersMap.get(key));
			i++;
		}

		List<XMLTestElement> listElm = targetBean.getList4VerticalRepeats1();
		assertEquals("{i擾jFVerticalRepeatsFList", ArrayList.class, listElm.getClass());
		assertEquals("{i擾jFVerticalRepeatsFsize()", 4, listElm.size());

		XMLTestElement elm = listElm.get(0);
		assertEquals("{i擾jFVerticalRepeats(Element)Fint", 1, elm.getId());
		assertEquals("{i擾jFVerticalRepeats(Element)FString", "c", elm.getFirstName());
		assertEquals("{i擾jFVerticalRepeats(Element)FString", "M", elm.getLastName());
		assertEquals("{i擾jFVerticalRepeats(Element)Fboolean", false, elm.isPremiumMember());
		assertEquals("{i擾jFVerticalRepeats(Element)Fdouble", 175.5, elm.getTall(), 0.1);
		assertEquals("{i擾jFVerticalRepeats(Element)Ftij", "2010N611", elm.getAdmissionDay());
		Map<String, String> useTimeMap = elm.getUseTimeMap();
		assertEquals("{i擾jFMappedCellFLinkedHashMap", LinkedHashMap.class, useTimeMap.getClass());
		assertEquals("{i擾jFMappedCellFsize()", 4, useTimeMap.keySet().size());
		keys = new String[]{"5", "6", "7", "8"};
		values = new String[]{"160", "182", "165", "177"};
		i = 0;
		for (String key : useTimeMap.keySet()) {
			assertEquals("{i擾jFMappedCellFkey" + i, keys[i], key);
			assertEquals("{i擾jFMappedCellFvalue" + i, values[i], useTimeMap.get(key));
			i++;
		}

		elm = listElm.get(1);
		assertEquals("{i擾jFVerticalRepeats(Element)Fint", 2, elm.getId());
		assertEquals("{i擾jFVerticalRepeats(Element)FString", "Dc", elm.getFirstName());
		assertEquals("{i擾jFVerticalRepeats(Element)FString", "M", elm.getLastName());
		assertEquals("{i擾jFVerticalRepeats(Element)Fboolean", true, elm.isPremiumMember());
		assertEquals("{i擾jFVerticalRepeats(Element)Fdouble", 178.5, elm.getTall(), 0.1);
		assertEquals("{i擾jFVerticalRepeats(Element)Ftij", "2010N620", elm.getAdmissionDay());
		useTimeMap = elm.getUseTimeMap();
		assertEquals("{i擾jFMappedCellFLinkedHashMap", LinkedHashMap.class, useTimeMap.getClass());
		assertEquals("{i擾jFMappedCellFsize()", 4, useTimeMap.keySet().size());
		keys = new String[]{"5", "6", "7", "8"};
		values = new String[]{"193", "188", "171", "165"};
		i = 0;
		for (String key : useTimeMap.keySet()) {
			assertEquals("{i擾jFMappedCellFkey" + i, keys[i], key);
			assertEquals("{i擾jFMappedCellFvalue" + i, values[i], useTimeMap.get(key));
			i++;
		}

		elm = listElm.get(2);
		assertEquals("{i擾jFVerticalRepeats(Element)Fint", 3, elm.getId());
		assertEquals("{i擾jFVerticalRepeats(Element)FString", "", elm.getFirstName());
		assertEquals("{i擾jFVerticalRepeats(Element)FString", "ƍN", elm.getLastName());
		assertEquals("{i擾jFVerticalRepeats(Element)Fboolean", false, elm.isPremiumMember());
		assertEquals("{i擾jFVerticalRepeats(Element)Fdouble", 165.0, elm.getTall(), 0.1);
		assertEquals("{i擾jFVerticalRepeats(Element)Ftij", "2010N618", elm.getAdmissionDay());
		useTimeMap = elm.getUseTimeMap();
		assertEquals("{i擾jFMappedCellFLinkedHashMap", LinkedHashMap.class, useTimeMap.getClass());
		assertEquals("{i擾jFMappedCellFsize()", 4, useTimeMap.keySet().size());
		keys = new String[]{"5", "6", "7", "8"};
		values = new String[]{"162", "155", "165", "166"};
		i = 0;
		for (String key : useTimeMap.keySet()) {
			assertEquals("{i擾jFMappedCellFkey" + i, keys[i], key);
			assertEquals("{i擾jFMappedCellFvalue" + i, values[i], useTimeMap.get(key));
			i++;
		}

		elm = listElm.get(3);
		assertEquals("{i擾jFVerticalRepeats(Element)Fint", 4, elm.getId());
		assertEquals("{i擾jFVerticalRepeats(Element)FString", "א", elm.getFirstName());
		assertEquals("{i擾jFVerticalRepeats(Element)FString", "KV", elm.getLastName());
		assertEquals("{i擾jFVerticalRepeats(Element)Fboolean", false, elm.isPremiumMember());
		assertEquals("{i擾jFVerticalRepeats(Element)Fdouble", 160.0, elm.getTall(), 0.1);
		assertEquals("{i擾jFVerticalRepeats(Element)Ftij", "2010N622", elm.getAdmissionDay());
		useTimeMap = elm.getUseTimeMap();
		assertEquals("{i擾jFMappedCellFLinkedHashMap", LinkedHashMap.class, useTimeMap.getClass());
		assertEquals("{i擾jFMappedCellFsize()", 4, useTimeMap.keySet().size());
		keys = new String[]{"5", "6", "7", "8"};
		values = new String[]{"143", "177", "151", "182"};
		i = 0;
		for (String key : useTimeMap.keySet()) {
			assertEquals("{i擾jFMappedCellFkey" + i, keys[i], key);
			assertEquals("{i擾jFMappedCellFvalue" + i, values[i], useTimeMap.get(key));
			i++;
		}

		XMLTestElement[] arrElm = targetBean.getArr4VerticalRepeats1();
		assertEquals("{i擾jFVerticalRepeatsFArray", XMLTestElement[].class, arrElm.getClass());
		assertEquals("{i擾jFVerticalRepeatsFsize()", 2, arrElm.length);

		elm = arrElm[0];
		assertEquals("{i擾jFVerticalRepeats(Element)Fint", 1, elm.getId());
		assertEquals("{i擾jFVerticalRepeats(Element)FString", "", elm.getFirstName());
		assertEquals("{i擾jFVerticalRepeats(Element)FString", "܂", elm.getLastName());
		assertEquals("{i擾jFVerticalRepeats(Element)Fboolean", true, elm.isPremiumMember());
		assertEquals("{i擾jFVerticalRepeats(Element)Fdouble", 156.0, elm.getTall(), 0.1);
		assertEquals("{i擾jFVerticalRepeats(Element)Ftij", "2010N615", elm.getAdmissionDay());
		useTimeMap = elm.getUseTimeMap();
		assertEquals("{i擾jFMappedCellFLinkedHashMap", LinkedHashMap.class, useTimeMap.getClass());
		assertEquals("{i擾jFMappedCellFsize()", 4, useTimeMap.keySet().size());
		keys = new String[]{"5", "6", "7", "8"};
		values = new String[]{"90", "56", "81", "23"};
		i = 0;
		for (String key : useTimeMap.keySet()) {
			assertEquals("{i擾jFMappedCellFkey" + i, keys[i], key);
			assertEquals("{i擾jFMappedCellFvalue" + i, values[i], useTimeMap.get(key));
			i++;
		}

		elm = arrElm[1];
		assertEquals("{i擾jFVerticalRepeats(Element)Fint", 2, elm.getId());
		assertEquals("{i擾jFVerticalRepeats(Element)FString", "", elm.getFirstName());
		assertEquals("{i擾jFVerticalRepeats(Element)FString", "", elm.getLastName());
		assertEquals("{i擾jFVerticalRepeats(Element)Fboolean", false, elm.isPremiumMember());
		assertEquals("{i擾jFVerticalRepeats(Element)Fdouble", 168.5, elm.getTall(), 0.1);
		assertEquals("{i擾jFVerticalRepeats(Element)Ftij", "2010N617", elm.getAdmissionDay());
		useTimeMap = elm.getUseTimeMap();
		assertEquals("{i擾jFMappedCellFLinkedHashMap", LinkedHashMap.class, useTimeMap.getClass());
		assertEquals("{i擾jFMappedCellFsize()", 4, useTimeMap.keySet().size());
		keys = new String[]{"5", "6", "7", "8"};
		values = new String[]{"112", "186", "78", "140"};
		i = 0;
		for (String key : useTimeMap.keySet()) {
			assertEquals("{i擾jFMappedCellFkey" + i, keys[i], key);
			assertEquals("{i擾jFMappedCellFvalue" + i, values[i], useTimeMap.get(key));
			i++;
		}

		listElm = targetBean.getList4HorizontalRepeats1();
		assertEquals("{i擾jFVerticalRepeatsFList", ArrayList.class, listElm.getClass());
		assertEquals("{i擾jFVerticalRepeatsFsize()", 4, listElm.size());

		elm = listElm.get(0);
		assertEquals("{i擾jFVerticalRepeats(Element)Fint", 1, elm.getId());
		assertEquals("{i擾jFVerticalRepeats(Element)FString", "cH", elm.getFirstName());
		assertEquals("{i擾jFVerticalRepeats(Element)FString", "MH", elm.getLastName());
		assertEquals("{i擾jFVerticalRepeats(Element)Fboolean", false, elm.isPremiumMember());
		assertEquals("{i擾jFVerticalRepeats(Element)Fdouble", 175.5, elm.getTall(), 0.1);
		assertEquals("{i擾jFVerticalRepeats(Element)Ftij", "2010N611", elm.getAdmissionDay());
		useTimeMap = elm.getUseTimeMap();
		assertEquals("{i擾jFMappedCellFLinkedHashMap", LinkedHashMap.class, useTimeMap.getClass());
		assertEquals("{i擾jFMappedCellFsize()", 4, useTimeMap.keySet().size());
		keys = new String[]{"5", "6", "7", "8"};
		values = new String[]{"160", "182", "165", "177"};
		i = 0;
		for (String key : useTimeMap.keySet()) {
			assertEquals("{i擾jFMappedCellFkey" + i, keys[i], key);
			assertEquals("{i擾jFMappedCellFvalue" + i, values[i], useTimeMap.get(key));
			i++;
		}

		elm = listElm.get(1);
		assertEquals("{i擾jFVerticalRepeats(Element)Fint", 2, elm.getId());
		assertEquals("{i擾jFVerticalRepeats(Element)FString", "DcH", elm.getFirstName());
		assertEquals("{i擾jFVerticalRepeats(Element)FString", "MH", elm.getLastName());
		assertEquals("{i擾jFVerticalRepeats(Element)Fboolean", true, elm.isPremiumMember());
		assertEquals("{i擾jFVerticalRepeats(Element)Fdouble", 178.5, elm.getTall(), 0.1);
		assertEquals("{i擾jFVerticalRepeats(Element)Ftij", "2010N620", elm.getAdmissionDay());
		useTimeMap = elm.getUseTimeMap();
		assertEquals("{i擾jFMappedCellFLinkedHashMap", LinkedHashMap.class, useTimeMap.getClass());
		assertEquals("{i擾jFMappedCellFsize()", 4, useTimeMap.keySet().size());
		keys = new String[]{"5", "6", "7", "8"};
		values = new String[]{"193", "188", "171", "165"};
		i = 0;
		for (String key : useTimeMap.keySet()) {
			assertEquals("{i擾jFMappedCellFkey" + i, keys[i], key);
			assertEquals("{i擾jFMappedCellFvalue" + i, values[i], useTimeMap.get(key));
			i++;
		}

		elm = listElm.get(2);
		assertEquals("{i擾jFVerticalRepeats(Element)Fint", 3, elm.getId());
		assertEquals("{i擾jFVerticalRepeats(Element)FString", "H", elm.getFirstName());
		assertEquals("{i擾jFVerticalRepeats(Element)FString", "ƍNH", elm.getLastName());
		assertEquals("{i擾jFVerticalRepeats(Element)Fboolean", false, elm.isPremiumMember());
		assertEquals("{i擾jFVerticalRepeats(Element)Fdouble", 165.0, elm.getTall(), 0.1);
		assertEquals("{i擾jFVerticalRepeats(Element)Ftij", "2010N618", elm.getAdmissionDay());
		useTimeMap = elm.getUseTimeMap();
		assertEquals("{i擾jFMappedCellFLinkedHashMap", LinkedHashMap.class, useTimeMap.getClass());
		assertEquals("{i擾jFMappedCellFsize()", 4, useTimeMap.keySet().size());
		keys = new String[]{"5", "6", "7", "8"};
		values = new String[]{"162", "155", "165", "166"};
		i = 0;
		for (String key : useTimeMap.keySet()) {
			assertEquals("{i擾jFMappedCellFkey" + i, keys[i], key);
			assertEquals("{i擾jFMappedCellFvalue" + i, values[i], useTimeMap.get(key));
			i++;
		}

		elm = listElm.get(3);
		assertEquals("{i擾jFVerticalRepeats(Element)Fint", 4, elm.getId());
		assertEquals("{i擾jFVerticalRepeats(Element)FString", "אH", elm.getFirstName());
		assertEquals("{i擾jFVerticalRepeats(Element)FString", "KVH", elm.getLastName());
		assertEquals("{i擾jFVerticalRepeats(Element)Fboolean", false, elm.isPremiumMember());
		assertEquals("{i擾jFVerticalRepeats(Element)Fdouble", 160.0, elm.getTall(), 0.1);
		assertEquals("{i擾jFVerticalRepeats(Element)Ftij", "2010N622", elm.getAdmissionDay());
		useTimeMap = elm.getUseTimeMap();
		assertEquals("{i擾jFMappedCellFLinkedHashMap", LinkedHashMap.class, useTimeMap.getClass());
		assertEquals("{i擾jFMappedCellFsize()", 4, useTimeMap.keySet().size());
		keys = new String[]{"5", "6", "7", "8"};
		values = new String[]{"143", "177", "151", "182"};
		i = 0;
		for (String key : useTimeMap.keySet()) {
			assertEquals("{i擾jFMappedCellFkey" + i, keys[i], key);
			assertEquals("{i擾jFMappedCellFvalue" + i, values[i], useTimeMap.get(key));
			i++;
		}

		arrElm = targetBean.getArr4HorizontalRepeats1();
		assertEquals("{i擾jFVerticalRepeatsFArray", XMLTestElement[].class, arrElm.getClass());
		assertEquals("{i擾jFVerticalRepeatsFsize()", 2, arrElm.length);

		elm = arrElm[0];
		assertEquals("{i擾jFVerticalRepeats(Element)Fint", 1, elm.getId());
		assertEquals("{i擾jFVerticalRepeats(Element)FString", "H", elm.getFirstName());
		assertEquals("{i擾jFVerticalRepeats(Element)FString", "܂H", elm.getLastName());
		assertEquals("{i擾jFVerticalRepeats(Element)Fboolean", true, elm.isPremiumMember());
		assertEquals("{i擾jFVerticalRepeats(Element)Fdouble", 156.0, elm.getTall(), 0.1);
		assertEquals("{i擾jFVerticalRepeats(Element)Ftij", "2010N615", elm.getAdmissionDay());
		useTimeMap = elm.getUseTimeMap();
		assertEquals("{i擾jFMappedCellFLinkedHashMap", LinkedHashMap.class, useTimeMap.getClass());
		assertEquals("{i擾jFMappedCellFsize()", 4, useTimeMap.keySet().size());
		keys = new String[]{"5", "6", "7", "8"};
		values = new String[]{"90", "56", "81", "23"};
		i = 0;
		for (String key : useTimeMap.keySet()) {
			assertEquals("{i擾jFMappedCellFkey" + i, keys[i], key);
			assertEquals("{i擾jFMappedCellFvalue" + i, values[i], useTimeMap.get(key));
			i++;
		}

		elm = arrElm[1];
		assertEquals("{i擾jFVerticalRepeats(Element)Fint", 2, elm.getId());
		assertEquals("{i擾jFVerticalRepeats(Element)FString", "H", elm.getFirstName());
		assertEquals("{i擾jFVerticalRepeats(Element)FString", "H", elm.getLastName());
		assertEquals("{i擾jFVerticalRepeats(Element)Fboolean", false, elm.isPremiumMember());
		assertEquals("{i擾jFVerticalRepeats(Element)Fdouble", 168.5, elm.getTall(), 0.1);
		assertEquals("{i擾jFVerticalRepeats(Element)Ftij", "2010N617", elm.getAdmissionDay());
		useTimeMap = elm.getUseTimeMap();
		assertEquals("{i擾jFMappedCellFLinkedHashMap", LinkedHashMap.class, useTimeMap.getClass());
		assertEquals("{i擾jFMappedCellFsize()", 4, useTimeMap.keySet().size());
		keys = new String[]{"5", "6", "7", "8"};
		values = new String[]{"112", "186", "78", "140"};
		i = 0;
		for (String key : useTimeMap.keySet()) {
			assertEquals("{i擾jFMappedCellFkey" + i, keys[i], key);
			assertEquals("{i擾jFMappedCellFvalue" + i, values[i], useTimeMap.get(key));
			i++;
		}


		bridge.save(
				"./files/template/ParserTest_Template.xls",
				"{",
				"./files/export/AnnotationParserTest_{.xls",
				targetBean);

		FileInputStream fileInputStream = null;
		try {
			fileInputStream = new FileInputStream("./files/export/AnnotationParserTest_{.xls");
			HSSFWorkbook workBook = new HSSFWorkbook(new POIFSFileSystem(fileInputStream));
			HSSFSheet sheet = workBook.getSheet("{");

			assertEquals("{i݁jFLabeledCellFString", "P", getCellValue(sheet, 42, 9, CELL_TYPE_STRING));
			assertEquals("{i݁jFLabeledCellFint", 45, getCellValue(sheet, 43, 9, CELL_TYPE_INT));
			assertEquals("{i݁jFLabeledCellFboolean", true, getCellValue(sheet, 44, 9, CELL_TYPE_BOOLEAN));
			assertEquals("{i݁jFLabeledCellFdouble", 78.56, (Double)getCellValue(sheet, 45, 9, CELL_TYPE_DOUBLE), 0.001);
			assertEquals("{i݁jFLabeledCellFtij", "2010/06/18", getCellValue(sheet, 46, 9, CELL_TYPE_DATE_STR));

			assertEquals("{i݁jFPointedCellFString", "ʒuɂ錟F", getCellValue(sheet, 14, 3, CELL_TYPE_STRING));
			assertEquals("{i݁jFPointedCellFint",234, getCellValue(sheet, 15, 3, CELL_TYPE_INT));
			assertEquals("{i݁jFPointedCellFboolean",false, getCellValue(sheet, 16, 3, CELL_TYPE_BOOLEAN));
			assertEquals("{i݁jFPointedCellFdouble",963.2, (Double)getCellValue(sheet, 17, 3, CELL_TYPE_DOUBLE), 0.001);
			assertEquals("{i݁jFPointedCellFtij","2010/06/22", getCellValue(sheet, 18, 3, CELL_TYPE_DATE_STR));

			assertEquals("{i݁jFMappedCellFkey1","5", getCellValue(sheet, 21, 2, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval1","0",   getCellValue(sheet, 22, 2, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFkey2","6", getCellValue(sheet, 21, 3, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval2","0",   getCellValue(sheet, 22, 3, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFkey3","7", getCellValue(sheet, 21, 4, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval3","1",   getCellValue(sheet, 22, 4, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFkey4","8", getCellValue(sheet, 21, 5, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval4","4",   getCellValue(sheet, 22, 5, CELL_TYPE_DATE_STR));

			assertEquals("{i݁jFVerticalRepeats(Element)Fint", 1, getCellValue(sheet, 3, 2, CELL_TYPE_INT));
			assertEquals("{i݁jFVerticalRepeats(Element)FString", "c", getCellValue(sheet, 3, 5, CELL_TYPE_STRING));
			assertEquals("{i݁jFVerticalRepeats(Element)FString", "M", getCellValue(sheet, 3, 6, CELL_TYPE_STRING));
			assertEquals("{i݁jFVerticalRepeats(Element)Fboolean", false, getCellValue(sheet, 3, 9, CELL_TYPE_BOOLEAN));
			assertEquals("{i݁jFVerticalRepeats(Element)Fdouble", 175.5, (Double)getCellValue(sheet, 3, 11, CELL_TYPE_DOUBLE), 0.1);
			assertEquals("{i݁jFVerticalRepeats(Element)Ftij", "2010N611", getCellValue(sheet, 3, 10, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFkey1","5", getCellValue(sheet, 2, 13, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFkey2","6", getCellValue(sheet, 2, 14, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFkey3","7", getCellValue(sheet, 2, 15, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFkey4","8", getCellValue(sheet, 2, 16, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval1","160", getCellValue(sheet, 3, 13, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval2","182", getCellValue(sheet, 3, 14, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval3","165", getCellValue(sheet, 3, 15, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval4","177", getCellValue(sheet, 3, 16, CELL_TYPE_DATE_STR));

			assertEquals("{i݁jFVerticalRepeats(Element)Fint", 2, getCellValue(sheet, 4, 2, CELL_TYPE_INT));
			assertEquals("{i݁jFVerticalRepeats(Element)FString", "Dc", getCellValue(sheet, 4, 5, CELL_TYPE_STRING));
			assertEquals("{i݁jFVerticalRepeats(Element)FString", "M", getCellValue(sheet, 4, 6, CELL_TYPE_STRING));
			assertEquals("{i݁jFVerticalRepeats(Element)Fboolean", true, getCellValue(sheet, 4, 9, CELL_TYPE_BOOLEAN));
			assertEquals("{i݁jFVerticalRepeats(Element)Fdouble", 178.5, (Double)getCellValue(sheet, 4, 11, CELL_TYPE_DOUBLE), 0.1);
			assertEquals("{i݁jFVerticalRepeats(Element)Ftij", "2010N620", getCellValue(sheet, 4, 10, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval1","193", getCellValue(sheet, 4, 13, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval2","188", getCellValue(sheet, 4, 14, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval3","171", getCellValue(sheet, 4, 15, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval4","165", getCellValue(sheet, 4, 16, CELL_TYPE_DATE_STR));

			assertEquals("{i݁jFVerticalRepeats(Element)Fint", 3, getCellValue(sheet, 5, 2, CELL_TYPE_INT));
			assertEquals("{i݁jFVerticalRepeats(Element)FString", "", getCellValue(sheet, 5, 5, CELL_TYPE_STRING));
			assertEquals("{i݁jFVerticalRepeats(Element)FString", "ƍN", getCellValue(sheet, 5, 6, CELL_TYPE_STRING));
			assertEquals("{i݁jFVerticalRepeats(Element)Fboolean", false, getCellValue(sheet, 5, 9, CELL_TYPE_BOOLEAN));
			assertEquals("{i݁jFVerticalRepeats(Element)Fdouble", 165.0, (Double)getCellValue(sheet, 5, 11, CELL_TYPE_DOUBLE), 0.1);
			assertEquals("{i݁jFVerticalRepeats(Element)Ftij", "2010N618", getCellValue(sheet, 5, 10, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval1","162", getCellValue(sheet, 5, 13, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval2","155", getCellValue(sheet, 5, 14, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval3","165", getCellValue(sheet, 5, 15, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval4","166", getCellValue(sheet, 5, 16, CELL_TYPE_DATE_STR));

			assertEquals("{i݁jFVerticalRepeats(Element)Fint", 4, getCellValue(sheet, 6, 2, CELL_TYPE_INT));
			assertEquals("{i݁jFVerticalRepeats(Element)FString", "א", getCellValue(sheet, 6, 5, CELL_TYPE_STRING));
			assertEquals("{i݁jFVerticalRepeats(Element)FString", "KV", getCellValue(sheet, 6, 6, CELL_TYPE_STRING));
			assertEquals("{i݁jFVerticalRepeats(Element)Fboolean", false, getCellValue(sheet, 6, 9, CELL_TYPE_BOOLEAN));
			assertEquals("{i݁jFVerticalRepeats(Element)Fdouble", 160.0, (Double)getCellValue(sheet, 6, 11, CELL_TYPE_DOUBLE), 0.1);
			assertEquals("{i݁jFVerticalRepeats(Element)Ftij", "2010N622", getCellValue(sheet, 6, 10, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval1","143", getCellValue(sheet, 6, 13, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval2","177", getCellValue(sheet, 6, 14, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval3","151", getCellValue(sheet, 6, 15, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval4","182", getCellValue(sheet, 6, 16, CELL_TYPE_DATE_STR));

			assertEquals("{i݁jFVerticalRepeats(Element)Fint", 1, getCellValue(sheet, 29, 2, CELL_TYPE_INT));
			assertEquals("{i݁jFVerticalRepeats(Element)FString", "", getCellValue(sheet, 29, 4, CELL_TYPE_STRING));
			assertEquals("{i݁jFVerticalRepeats(Element)FString", "܂", getCellValue(sheet, 29, 5, CELL_TYPE_STRING));
			assertEquals("{i݁jFVerticalRepeats(Element)Fboolean", true, getCellValue(sheet, 29, 7, CELL_TYPE_BOOLEAN));
			assertEquals("{i݁jFVerticalRepeats(Element)Fdouble", 156.0, (Double)getCellValue(sheet, 29, 8, CELL_TYPE_DOUBLE), 0.1);
			assertEquals("{i݁jFVerticalRepeats(Element)Ftij", "2010N615", getCellValue(sheet, 29, 6, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFkey1","5", getCellValue(sheet, 28, 14, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFkey2","6", getCellValue(sheet, 28, 15, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFkey3","7", getCellValue(sheet, 28, 16, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFkey4","8", getCellValue(sheet, 28, 17, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval1","90", getCellValue(sheet, 29, 14, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval2","56", getCellValue(sheet, 29, 15, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval3","81", getCellValue(sheet, 29, 16, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval4","23", getCellValue(sheet, 29, 17, CELL_TYPE_DATE_STR));

			assertEquals("{i݁jFVerticalRepeats(Element)Fint", 2, getCellValue(sheet, 30, 2, CELL_TYPE_INT));
			assertEquals("{i݁jFVerticalRepeats(Element)FString", "", getCellValue(sheet, 30, 4, CELL_TYPE_STRING));
			assertEquals("{i݁jFVerticalRepeats(Element)FString", "", getCellValue(sheet, 30, 5, CELL_TYPE_STRING));
			assertEquals("{i݁jFVerticalRepeats(Element)Fboolean", false, getCellValue(sheet, 30, 7, CELL_TYPE_BOOLEAN));
			assertEquals("{i݁jFVerticalRepeats(Element)Fdouble", 168.5, (Double)getCellValue(sheet, 30, 8, CELL_TYPE_DOUBLE), 0.1);
			assertEquals("{i݁jFVerticalRepeats(Element)Ftij", "2010N617", getCellValue(sheet, 30, 6, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval1","112", getCellValue(sheet, 30, 14, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval2","186", getCellValue(sheet, 30, 15, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval3","78", getCellValue(sheet, 30, 16, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval4","140", getCellValue(sheet, 30, 17, CELL_TYPE_DATE_STR));

			assertEquals("{i݁jFVerticalRepeats(Element)Fint", 1, getCellValue(sheet, 50, 3, CELL_TYPE_INT));
			assertEquals("{i݁jFVerticalRepeats(Element)FString", "cH", getCellValue(sheet, 53, 3, CELL_TYPE_STRING));
			assertEquals("{i݁jFVerticalRepeats(Element)FString", "MH", getCellValue(sheet, 54, 3, CELL_TYPE_STRING));
			assertEquals("{i݁jFVerticalRepeats(Element)Fboolean", false, getCellValue(sheet, 60, 3, CELL_TYPE_BOOLEAN));
			assertEquals("{i݁jFVerticalRepeats(Element)Fdouble", 175.5, (Double)getCellValue(sheet, 59, 3, CELL_TYPE_DOUBLE), 0.1);
			assertEquals("{i݁jFVerticalRepeats(Element)Ftij", "2010N611", getCellValue(sheet, 52, 3, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFkey1","5", getCellValue(sheet, 62, 2, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFkey2","6", getCellValue(sheet, 63, 2, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFkey3","7", getCellValue(sheet, 64, 2, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFkey4","8", getCellValue(sheet, 65, 2, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval1","160", getCellValue(sheet, 62, 3, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval2","182", getCellValue(sheet, 63, 3, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval3","165", getCellValue(sheet, 64, 3, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval4","177", getCellValue(sheet, 65, 3, CELL_TYPE_DATE_STR));

			assertEquals("{i݁jFVerticalRepeats(Element)Fint", 2, getCellValue(sheet, 50, 4, CELL_TYPE_INT));
			assertEquals("{i݁jFVerticalRepeats(Element)FString", "DcH", getCellValue(sheet, 53, 4, CELL_TYPE_STRING));
			assertEquals("{i݁jFVerticalRepeats(Element)FString", "MH", getCellValue(sheet, 54, 4, CELL_TYPE_STRING));
			assertEquals("{i݁jFVerticalRepeats(Element)Fboolean", true, getCellValue(sheet, 60, 4, CELL_TYPE_BOOLEAN));
			assertEquals("{i݁jFVerticalRepeats(Element)Fdouble", 178.5, (Double)getCellValue(sheet, 59, 4, CELL_TYPE_DOUBLE), 0.1);
			assertEquals("{i݁jFVerticalRepeats(Element)Ftij", "2010N620", getCellValue(sheet, 52, 4, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval1","193", getCellValue(sheet, 62, 4, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval2","188", getCellValue(sheet, 63, 4, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval3","171", getCellValue(sheet, 64, 4, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval4","165", getCellValue(sheet, 65, 4, CELL_TYPE_DATE_STR));

			assertEquals("{i݁jFVerticalRepeats(Element)Fint", 3, getCellValue(sheet, 50, 5, CELL_TYPE_INT));
			assertEquals("{i݁jFVerticalRepeats(Element)FString", "H", getCellValue(sheet, 53, 5, CELL_TYPE_STRING));
			assertEquals("{i݁jFVerticalRepeats(Element)FString", "ƍNH", getCellValue(sheet, 54, 5, CELL_TYPE_STRING));
			assertEquals("{i݁jFVerticalRepeats(Element)Fboolean", false, getCellValue(sheet, 60, 5, CELL_TYPE_BOOLEAN));
			assertEquals("{i݁jFVerticalRepeats(Element)Fdouble", 165.0, (Double)getCellValue(sheet, 59, 5, CELL_TYPE_DOUBLE), 0.1);
			assertEquals("{i݁jFVerticalRepeats(Element)Ftij", "2010N618", getCellValue(sheet, 52, 5, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval1","162", getCellValue(sheet, 62, 5, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval2","155", getCellValue(sheet, 63, 5, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval3","165", getCellValue(sheet, 64, 5, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval4","166", getCellValue(sheet, 65, 5, CELL_TYPE_DATE_STR));

			assertEquals("{i݁jFVerticalRepeats(Element)Fint", 4, getCellValue(sheet, 50, 6, CELL_TYPE_INT));
			assertEquals("{i݁jFVerticalRepeats(Element)FString", "אH", getCellValue(sheet, 53, 6, CELL_TYPE_STRING));
			assertEquals("{i݁jFVerticalRepeats(Element)FString", "KVH", getCellValue(sheet, 54, 6, CELL_TYPE_STRING));
			assertEquals("{i݁jFVerticalRepeats(Element)Fboolean", false, getCellValue(sheet, 60, 9, CELL_TYPE_BOOLEAN));
			assertEquals("{i݁jFVerticalRepeats(Element)Fdouble", 160.0, (Double)getCellValue(sheet, 59, 6, CELL_TYPE_DOUBLE), 0.1);
			assertEquals("{i݁jFVerticalRepeats(Element)Ftij", "2010N622", getCellValue(sheet, 52, 6, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval1","143", getCellValue(sheet, 62, 6, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval2","177", getCellValue(sheet, 63, 6, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval3","151", getCellValue(sheet, 64, 6, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval4","182", getCellValue(sheet, 65, 6, CELL_TYPE_DATE_STR));

			assertEquals("{i݁jFVerticalRepeats(Element)Fint", 1, getCellValue(sheet, 77, 3, CELL_TYPE_INT));
			assertEquals("{i݁jFVerticalRepeats(Element)FString", "H", getCellValue(sheet, 80, 3, CELL_TYPE_STRING));
			assertEquals("{i݁jFVerticalRepeats(Element)FString", "܂H", getCellValue(sheet, 81, 3, CELL_TYPE_STRING));
			assertEquals("{i݁jFVerticalRepeats(Element)Fboolean", true, getCellValue(sheet, 78, 3, CELL_TYPE_BOOLEAN));
			assertEquals("{i݁jFVerticalRepeats(Element)Fdouble", 156.0, (Double)getCellValue(sheet, 87, 3, CELL_TYPE_DOUBLE), 0.1);
			assertEquals("{i݁jFVerticalRepeats(Element)Ftij", "2010N615", getCellValue(sheet, 79, 3, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFkey1","5", getCellValue(sheet, 89, 2, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFkey2","6", getCellValue(sheet, 90, 2, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFkey3","7", getCellValue(sheet, 91, 2, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFkey4","8", getCellValue(sheet, 92, 2, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval1","90", getCellValue(sheet, 89, 3, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval2","56", getCellValue(sheet, 90, 3, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval3","81", getCellValue(sheet, 91, 3, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval4","23", getCellValue(sheet, 92, 3, CELL_TYPE_DATE_STR));

			assertEquals("{i݁jFVerticalRepeats(Element)Fint", 2, getCellValue(sheet, 77, 4, CELL_TYPE_INT));
			assertEquals("{i݁jFVerticalRepeats(Element)FString", "H", getCellValue(sheet, 80, 4, CELL_TYPE_STRING));
			assertEquals("{i݁jFVerticalRepeats(Element)FString", "H", getCellValue(sheet, 81, 4, CELL_TYPE_STRING));
			assertEquals("{i݁jFVerticalRepeats(Element)Fboolean", false, getCellValue(sheet, 78, 4, CELL_TYPE_BOOLEAN));
			assertEquals("{i݁jFVerticalRepeats(Element)Fdouble", 168.5, (Double)getCellValue(sheet, 87, 4, CELL_TYPE_DOUBLE), 0.1);
			assertEquals("{i݁jFVerticalRepeats(Element)Ftij", "2010N617", getCellValue(sheet, 79, 4, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval1","112", getCellValue(sheet, 89, 4, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval2","186", getCellValue(sheet, 90, 4, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval3","78", getCellValue(sheet, 91, 4, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval4","140", getCellValue(sheet, 92, 4, CELL_TYPE_DATE_STR));
		} finally {
			try { fileInputStream.close(); } catch (Exception e) { }
		}
	}

	/**
	 * sȒ`̃eXg
	 * Bean:position̏s
	 * XML̏G[
	 * @throws ExcelPOJOException
	 */
	@Test(expected=XmlBeanDefinitionStoreException.class)
	public void testBeanInvalidPositionFormat() throws ExcelPOJOException {
		ApplicationContext context = new ClassPathXmlApplicationContext("./config/XMLTestsInvalidPosition.xml");
		ExcelPOJOBridge bridge = (ExcelPOJOBridge)context.getBean("testBeanInvalidPositionFormat");
		@SuppressWarnings("unused")
		XMLTestElement targetBean = (XMLTestElement) bridge.load("./files/upload/ParserTest.xls", "{");
	}

	/**
	 * sȒ`̃eXg
	 * Bean:listClassɊYNX̔złȂAListłȂNXw
	 * @throws ExcelPOJOException
	 */
	@Test(expected=ExcelPOJOException.class)
	public void testBeanListClassNotListSpacified() throws Exception {
		try {
			ApplicationContext context = new ClassPathXmlApplicationContext("./config/testBeanListClassNotListSpacified.xml");
			ExcelPOJOBridge bridge = (ExcelPOJOBridge)context.getBean("testBeanListClassNotListSpacified");
			@SuppressWarnings("unused")
			XMLTestElement targetBean = (XMLTestElement) bridge.load("./files/upload/ParserTest.xls", "{");
		} catch (Exception e) {
			assertEquals("Bean:listClassɊYNX̔złȂAListłȂNXw",
					"java.lang.IllegalArgumentException: There is an invalid class in the listClass specification. ",
					e.getMessage());
			throw e;
		}
	}

	/**
	 * sȒ`̃eXg
	 * Bean:listClassɑ݂ȂNXw
	 * @throws ExcelPOJOException
	 */
	@Test(expected=ExcelPOJOException.class)
	public void testBeanListClassNotExistClassSpacified() throws Exception {
		try {
			ApplicationContext context = new ClassPathXmlApplicationContext("./config/testBeanListClassNotExistClassSpacified.xml");
			ExcelPOJOBridge bridge = (ExcelPOJOBridge)context.getBean("testBeanListClassNotExistClassSpacified");
			@SuppressWarnings("unused")
			XMLTestElement targetBean = (XMLTestElement) bridge.load("./files/upload/ParserTest.xls", "{");
		} catch (Exception e) {
			assertEquals("Bean:listClassɊYNX̔złȂAListłȂNXw",
					"java.lang.ClassNotFoundException: XXXX",
					e.getMessage());
			throw e;
		}
	}


	/**
	 * sȒ`̃eXg
	 * Bean:rangeɕsȃtH[}bgw
	 * XML̏G[
	 * @throws ExcelPOJOException
	 */
	@Test(expected=XmlBeanDefinitionStoreException.class)
	public void testBeanRangeInvalidFormat() throws ExcelPOJOException {
		ApplicationContext context = new ClassPathXmlApplicationContext("./config/XMLTestsInvalidRange.xml");
		ExcelPOJOBridge bridge = (ExcelPOJOBridge)context.getBean("testBeanRangeInvalidFormat");
		@SuppressWarnings("unused")
		XMLTestElement targetBean = (XMLTestElement) bridge.load("./files/upload/ParserTest.xls", "{");
	}

}
